function [distilled_data] = punc_distill(distance,vector,lum,varargin)
%A Little function that takes the compressed data matrices produced by
%punc2mat, and using parameters provided by the user distill the dataset
%further into a matrix of only pertinent data.
%Synatax:   [distilled_data] = punc_distill(distance,vector,'origin',1,...
%               'termini',2,'3',[-1 1],'4',[1 0 45],'distance',1); 
%Input:     distance = distance data structure generated by punc2mat
%           vector = vector data structure generated by punc2mat
%           lum = luminance data structure generated by punc2mat
%           origin = the channel used to provide the origin of the base
%               vector, e.g., the channel providing the base pivots.
%           termini = the channel used to provide the termini of the base
%               vector, e.g., the channel used with the origin to make the
%               base vector.
%           '1...x' = the syntax '1',[a b c] is parsed this way.  The first
%               number in quotes represent the channel, thus '1' = channel
%               1 and '3' = channel 3.  The vector [a b c] = the position
%               of angles_xy, angles_xz and angles_xyz to be excluded.  So,
%               a = 1, is to exclude all angles_xy left of the base vector.
%               a = -1, is to exclude all angles_xy right of the base
%               vector.  a = 0, is to not exclude point.  c, is
%               expressed as an angle and its sign will reflect whether you
%               want to exclude angles larger than c or smaller than c,
%               e.g., c = 45, is to excluded all angles_xyz above 45deg.
%               c = -45, is to exclude all angles_xyz under 45deg.  If c is
%               left empty, then it is assumed to not be used for
%               distillation.
%               Note:
%               channels that are in the dataset, but not described in this
%               notiation system will only be distilled by the shortest
%               distance from the origin.
%           'distance' = turn filtering by distance on and off.  Default =
%               1 or on.  0 = off
%output:    distilled_data = one array of all of the parameters, i.e.,
%               distances and vectors and vector positions, for channal
%               origin_ch, which is the base pivot.

[origin_ch,termini_ch,vector_param,dist] = parse(varargin);     %Parse the input

ch_list = [];                       %Initialize
for i = 1:size(vector_param,1)          %step through the vectors parameters that needs to be filtered to create a channels list for analysis.
    ch_list = horzcat(ch_list,vector_param{i,1});
end

%lets pull up the vector data and go.
distilled_data = [];    %initiate output array
for i = 1:size(vector(origin_ch).ch)    %step through all the vertices
    data_mat_tmp = [];      %initiate temporary matrix
    %the base filter. the prime index.  This is how we make sure there are
    %no repeats.
    [curr_idx,col] = find(distance(origin_ch).ch{1,1,termini_ch}(:,1)==i);   %find the rows for current vertex
    if dist         %distance filter is on
        ddi_prime = distance(origin_ch).ch{1,1,termini_ch}(curr_idx,:);    %del_dist_idx_prime - the base vector distance filter array
        [ddi_prime,col] = find(ddi_prime(:,9)==min(ddi_prime(:,9)));        %ddi_prime you are the only one I want index
    else            %distance filter is off
        ddi_prime = 1:size(distance(origin_ch).ch{1,1,termini_ch}(curr_idx,:),1);
    end
    for j = 1:size(vector(origin_ch).ch{i,1,termini_ch},3)  %step through the # of channels compared to the origin
        if j~=origin_ch         %skip the origin channel because everything will be [] anyway
            %now pull out the data matrix of the channel to be analyzed
            vector_tmp = vector(origin_ch).ch{i,1,termini_ch}{1,1,j};
            [curr_idx,col] = find(distance(origin_ch).ch{1,1,j}(:,1)==i);   %find the rows for current vertex
            if ~isempty(vector_tmp)     %if there is vector data not termini_ch
                dist_tmp = repmat(distance(origin_ch).ch{1,1,j}(curr_idx,:),[1 1 size(vector_tmp,3)]); %make sure dist_temp match in all dimensions.
                lum_tmp = repmat(lum(origin_ch).ch{1,1,j}(curr_idx,:),[1 1 size(vector_tmp,3)]);    %luminance is coming for the right
            else
                dist_tmp = distance(origin_ch).ch{1,1,j}(curr_idx,:);           %get distance for this vertex
                lum_tmp = lum(origin_ch).ch{1,1,j}(curr_idx,:);                 %tagging along
            end
            if any(j==ch_list)              %if this channel need to be distilled
                %pull out vector data
                xy = vector_param{j,2}(1,1);    %xy requirment
                xz = vector_param{j,2}(1,2);    %xz requirment
                try
                    xyz = vector_param{j,2}(1,3);   %xyz angle requirment
                catch
                    xyz = NaN;
                end
                if size(vector_tmp,3)==1        %simple array processing
                    if isnan(xyz)      %if we don't care about the coplanar angle
                        [del_vec_idx,col] = find(vector_tmp(:,12)==xy | vector_tmp(:,14)==xz);    %find all points that match the delete parameter for xy & xz
                    else               %if we do care about the coplanar angle
                        if xyz>0    %exclude larger angles
                            [del_vec_idx,col] = find(vector_tmp(:,12)==xy | vector_tmp(:,14)==xz | vector_tmp(:,15)>abs(xyz));  %find all points
                        else        %exclude smaller angles
                            [del_vec_idx,col] = find(vector_tmp(:,12)==xy | vector_tmp(:,14)==xz | vector_tmp(:,15)<abs(xyz));  %find all points
                        end
                    end
                    vector_tmp(del_vec_idx,:) = [];
                    dist_tmp(del_vec_idx,:) = [];
                    lum_tmp(del_vec_idx,:) = [];
                else                            %process as a matrix
                    for l = 1:size(vector_tmp,3)
                        if max(l==ddi_prime)    %proceed only if necessary
                            if isnan(xyz)      %if we don't care about the coplanar angle
                                [del_vec_idx,col] = find(vector_tmp(:,12,l)==xy | vector_tmp(:,14,l)==xz);    %find all points that match the delete parameter for xy & xz
                            else               %if we do care about the coplanar angle
                                if xyz>0    %exclude larger angles
                                    [del_vec_idx,col] = find(vector_tmp(:,12,l)==xy | vector_tmp(:,14,l)==xz | vector_tmp(:,15,l)>abs(xyz));  %find all points
                                else        %exclude smaller angles
                                    [del_vec_idx,col] = find(vector_tmp(:,12,l)==xy | vector_tmp(:,14,l)==xz | vector_tmp(:,15,l)<abs(xyz));  %find all points
                                end
                            end
                            v_tmp = vector_tmp(:,:,l);
                            d_tmp = dist_tmp(:,:,l);
                            l_tmp = lum_tmp(:,:,l);
                            v_tmp(del_vec_idx,:) = [];       %filter out rows from vector data; for now set to zero to maintain matrix integrity
                            d_tmp(del_vec_idx,:) = [];       %filter out rows from distance data
                            l_tmp(del_vec_idx,:) = [];
                            v_tmp_x{:,:,l} = v_tmp;           %output cell
                            d_tmp_x{:,:,l} = d_tmp;           %output in cell format
                            l_tmp_x{:,:,l} = l_tmp;
                        end
                    end
                    vector_tmp = v_tmp_x;               %output cell arrays
                    dist_tmp = d_tmp_x;
                    lum_tmp = l_tmp_x;
                    clear v_tmp d_tmp d_tmp_x v_tmp_x l_tmp_x   %clear temp arrays
                end
            end
            %now finded the shortest distance/distance filter the dataset
            if j~=termini_ch        %vector is not empty
                if size(vector_tmp,3)==1        %no funny 3d matrix business
                        if iscell(dist_tmp)         %we got to deal cell business
                            dist_tmp = cell2mat(dist_tmp);  %back to basics
                            vector_tmp = cell2mat(vector_tmp);
                            lum_tmp = cell2mat(lum_tmp);
                        end
                        if dist     %distance filter is on
                            [del_dist_idx,col] = find(dist_tmp(:,9)>min(dist_tmp(:,9)));  %find the shortest distance.
                            vector_tmp(del_dist_idx,:) = [];       %filter out rows from vector data
                            dist_tmp(del_dist_idx,:) = [];       %filter out rows from distance data
                            lum_tmp(del_dist_idx,:) = [];
                        end
                    %make sure that vector_tmp and dist_tmp are not empty
                    if isempty(dist_tmp)
                        dist_tmp = NaN(1,9);
                        lum_tmp = NaN(1,9);
                    end
                    if isempty(vector_tmp)
                        vector_tmp = NaN(1,15);
                    end
                else        %funny matrix business
                    for l = 1:size(vector_tmp,3)
                        if max(l==ddi_prime)        %pass only if you match
                            if iscell(vector_tmp)
                                if dist     %distance filter is on
                                    [del_dist_idx,col] = find(dist_tmp{1,1,l}(:,9)>min(dist_tmp{1,1,l}(:,9)));  %find the shortest distance.
                                end
                                v_tmp = vector_tmp{:,:,l};
                                d_tmp = dist_tmp{:,:,l};
                                l_tmp = lum_tmp{:,:,l};
                            else
                                if dist     %distance filter is on
                                    [del_dist_idx,col] = find(dist_tmp(:,9,l)>min(dist_tmp(:,9,l)));  %find the shortest distance.
                                end
                                v_tmp = vector_tmp(:,:,l);
                                d_tmp = dist_tmp(:,:,l);
                                l_tmp = lum_tmp(:,:,l);
                            end
                            if dist     %distance filter is on
                                v_tmp(del_dist_idx,:) = [];       %filter out rows from vector data; for now set to zero to maintain matrix integrity
                                d_tmp(del_dist_idx,:) = [];       %filter out rows from distance data
                                l_tmp(del_dist_idx,:) = [];
                            end
                            %make sure that vector_tmp and dist_tmp are not empty
                            if isempty(d_tmp)
                                d_tmp = NaN(1,9);
                                l_tmp = NaN(1,9);
                            end
                            if isempty(v_tmp)
                                v_tmp = NaN(1,15);
                            end
                            v_tmp_x{:,:,l} = v_tmp;           %output cell
                            d_tmp_x{:,:,l} = d_tmp;           %output in cell format
                            l_tmp_x{:,:,l} = l_tmp;
                        end
                    end
                    %make sure out is not cell if only 1 point is present
                    if size(v_tmp_x,3)==1
                        v_tmp_x = v_tmp_x{:,:,1};
                        d_tmp_x = d_tmp_x{:,:,1};
                        l_tmp_x = l_tmp_x{:,:,1};
                    end
                    vector_tmp = v_tmp_x;               %output cell arrays
                    dist_tmp = d_tmp_x;
                    lum_tmp = l_tmp_x;
                    clear v_tmp d_tmp d_tmp_x v_tmp_x l_tmp_x   %clear temp arrays
                end
            else                    %termini channel
                if dist     %distance filter is on
                    [del_dist_idx,col] = find(dist_tmp(:,9)>min(dist_tmp(:,9)));  %find the shortest distance.
                    dist_tmp(del_dist_idx,:) = [];       %filter out rows from distance data
                    lum_tmp(del_dist_idx,:) = [];
                end
                %make sure that vector_tmp and dist_tmp are not empty
                if isempty(dist_tmp)
                    dist_tmp = NaN(1,9);
                    lum_tmp = NaN(1,9);
                end
            end
            %put the data in the output matrix
            if j==termini_ch    %the termini channel of the base vector
                if isempty(data_mat_tmp)          %first through
                    data_mat_tmp = horzcat(repmat(i,size(dist_tmp,1),1),repmat(j,size(dist_tmp,1),1),...
                        dist_tmp(:,2:end),lum_tmp(:,9));   %3 indexes and all pts.
                else                %not first time
                    for k = 1:size(data_mat_tmp,1)                  %step through the current output dataset rows
                        cache = horzcat(repmat(data_mat_tmp(k,1:5),size(dist_tmp,1),1),repmat(j,size(dist_tmp,1),1),...
                            dist_tmp(:,2:end),lum_tmp(:,9),repmat(data_mat_tmp(k,6:end),size(dist_tmp,1),1));  %1 index, 1 new vertex & vector and distance data.
                        if k~=1       %not first time through
                            d_tmp = vertcat(d_tmp,cache);     %combine matrix
                        else          %first timer
                            d_tmp = cache;       %data matrix
                        end
                    end
                    data_mat_tmp = d_tmp;       %finalize reworked matrix
                    clear d_tmp cache
                end
            else        %all channels other than origin and termini of base vector
                if isempty(data_mat_tmp)            %first time through
                    if size(vector_tmp,3)==1        %simple basic
                        data_mat_tmp = vertcat(data_mat_tmp,horzcat(repmat(i,size(vector_tmp,1),1),repmat(j,size(vector_tmp,1),1),...
                            vector_tmp(:,8:end),dist_tmp(:,9),lum_tmp(:,9)));   %3 indexes and all pts.
                    else                            %process cell
                        for l = 1:size(vector_tmp,3)
                            if ~isempty(vector_tmp{1,1,l})      %ignore empty fields
                            data_mat_tmp = vertcat(data_mat_tmp,horzcat(repmat(i,size(vector_tmp{1,1,l},1),1),repmat(j,...
                                size(vector_tmp{1,1,l},1),1),vector_tmp{1,1,l}(:,8:end),dist_tmp{1,1,l}(:,9),lum_tmp{1,1,l}(:,9)));   %3 indexes and all pts.
                            end
                        end
                    end
                else                                %not first time
                    for k = 1:size(data_mat_tmp,1)                  %step through the current output dataset rows
                        cache = [];         %initialize current cache.
                        if size(vector_tmp,3)==1        %easy does it.
                            if ~iscell(vector_tmp)      %not a cell processing
                                d_tmp = vertcat(cache,horzcat(repmat(data_mat_tmp(k,:),size(vector_tmp,1),1),repmat(j,...
                                    size(vector_tmp,1),1),vector_tmp(:,8:end),dist_tmp(:,9),lum_tmp(:,9))); %1 index, 1 new vertex & vector and distance data.
                            else                        %is a cell
                                d_tmp = vertcat(cache,horzcat(repmat(data_mat_tmp(k,:),size(vector_tmp,1),1),repmat(j,...
                                    size(vector_tmp,1),1),vector_tmp{1,1,1}(:,8:end),dist_tmp{1,1,1}(:,9),lum_tmp{1,1,1}(:,9))); 
                            end
                        else                            %life is complicated
                            for l = 1:size(vector_tmp,3)
                                cache = [];
                                if ~isempty(vector_tmp{1,1,l})      %ignore empty fields
                                    cache = vertcat(cache,horzcat(repmat(data_mat_tmp(k,:),size(vector_tmp{1,1,l},1),1),...
                                        repmat(j,size(vector_tmp{1,1,l},1),1),vector_tmp{1,1,l}(:,8:end),dist_tmp{1,1,l}(:,9),lum_tmp{1,1,l}(:,9)));
                                    if l~=1         %Not first time through
                                        d_tmp2 = vertcat(d_tmp2,cache);     %combine matrix
                                    else            %first time through
                                        d_tmp2 = cache;       %data matrix
                                    end
                                end
                            end
                            if k==1       %like a virgin
                                d_tmp = d_tmp2;       %finalize reworked matrix
                            else                    %not the first time.
                                d_tmp = vertcat(d_tmp,d_tmp2);  
                            end
                            clear d_tmp2 cache
                        end
                    end
                    data_mat_tmp = d_tmp;
                    clear d_tmp
                end
            end
        end
    end
    %store away the data in  the full data matrix
    if isempty(distilled_data)     %first time through
        distilled_data = data_mat_tmp;
    else        %not first time through
        distilled_data = vertcat(distilled_data,data_mat_tmp);      %add data to structure
    end
    clear data_mat_tmp dist_tmp vector_tmp
end
            
%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [origin_ch,termini_ch,vector_param,dist] = parse(input)

origin_ch = 1;  %Default Initialized.
termini_ch = 2;  %Center is off at default
vector_param = {};  %vector paramters is empty by default
dist = 1;           %distance filtering on.

%Parse the input
if ~isempty(input)
    for i = 1:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'origin'
                    origin_ch = input{1,i+1};
                case 'termini'
                    termini_ch = input{1,i+1};
                case 'distance'
                    dist = input{1,i+1};
                otherwise
                    if ~isempty(str2num(input{1,i}))    %pick up the casese where '1'...etc. is inputed
                        vector_idx = str2num(input{1,i});                                %roll the index up by 1
                        vector_param{vector_idx,1} = vector_idx;    %store the channel number
                        vector_param{vector_idx,2} = input{1,i+1};           %store the parameters
                    else                                %error
                        warning(['Your input ',input{1,i},' is not recognized.']);
                    end
            end
        end
    end
end